/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.gunner;

import com.google.common.base.Preconditions;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.common.entity.ZombieGunnerEntity;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.resource.gunner.GunnerGlobalProperties;
import dev.toma.gunsrpg.resource.gunner.IDifficultyProperty;
import dev.toma.gunsrpg.resource.gunner.SimpleDifficultyProperty;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.Difficulty;

public final class GunnerLoadoutInstance {
    private final int weight;
    private final GunItem weapon;
    private final IDifficultyProperty<IAmmoMaterial> ammo;
    private final int magCapacity;
    private final IDifficultyProperty<Integer> reloadTime;
    private final IDifficultyProperty<Integer> firerate;
    private final IDifficultyProperty<Float> damageMultiplier;
    private final float baseInaccuracy;
    private final float accuracyBonus;
    private final int burstSize;
    private final IDifficultyProperty<Integer> burstDelay;
    private final int capColor;

    private GunnerLoadoutInstance(Builder builder) {
        this.weight = builder.weight;
        this.weapon = builder.weapon;
        this.ammo = builder.ammo;
        this.magCapacity = builder.magCapacity;
        this.reloadTime = builder.reloadTime;
        this.firerate = builder.firerate;
        this.damageMultiplier = builder.damageMultiplier;
        this.baseInaccuracy = builder.baseInaccuracy;
        this.accuracyBonus = builder.accuracyBonus;
        this.burstSize = builder.burstSize;
        this.burstDelay = builder.burstDelay;
        this.capColor = builder.capColor;
    }

    public void applyGear(ZombieGunnerEntity entity, Difficulty difficulty) {
        ItemStack stack = new ItemStack((IItemProvider)this.weapon);
        IAmmoMaterial material = this.ammo.getProperty(difficulty);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("ammo", Integer.MAX_VALUE);
        nbt.func_74778_a("material", material.getMaterialID().toString());
        nbt.func_74768_a("firemode", 0);
        stack.func_77982_d(nbt);
        entity.func_184201_a(EquipmentSlotType.MAINHAND, stack);
        entity.setDamageMultiplier(this.damageMultiplier.getProperty(difficulty).floatValue());
        entity.setInaccuracy(this.getCalculatedInaccuracy(difficulty));
        entity.setFirerate(this.firerate.getProperty(difficulty));
        entity.setMagCapacity(this.magCapacity);
        entity.setReloadTime(this.reloadTime.getProperty(difficulty));
        entity.setBurstSize(this.burstSize);
        entity.setBurstDelay(this.burstDelay.getProperty(difficulty));
        entity.setCapColor(this.capColor);
    }

    public int getWeight() {
        return this.weight;
    }

    public float getCalculatedInaccuracy(Difficulty difficulty) {
        return this.baseInaccuracy + (float)difficulty.func_151525_a() * this.accuracyBonus;
    }

    public static class Builder {
        private int weight;
        private GunItem weapon;
        private IDifficultyProperty<IAmmoMaterial> ammo;
        private int magCapacity;
        private IDifficultyProperty<Integer> reloadTime;
        private IDifficultyProperty<Integer> firerate;
        private IDifficultyProperty<Float> damageMultiplier;
        private float baseInaccuracy;
        private float accuracyBonus;
        private int burstSize;
        private IDifficultyProperty<Integer> burstDelay = diff -> 0;
        private int capColor = -1;

        public void setupGlobal(GunnerGlobalProperties properties) {
            this.damageMultiplier = new SimpleDifficultyProperty<Float>(Float.valueOf(properties.getDamageMultiplier()));
            this.baseInaccuracy = properties.getInaccuracy();
            this.accuracyBonus = properties.getAccuracyBonus();
        }

        public void weight(int weight) {
            this.weight = weight;
        }

        public void weapon(GunItem weapon) {
            this.weapon = weapon;
        }

        public void ammo(IDifficultyProperty<IAmmoMaterial> ammo) {
            this.ammo = ammo;
        }

        public void magCapacity(int magCapacity) {
            this.magCapacity = magCapacity;
        }

        public void reloadTime(IDifficultyProperty<Integer> reloadTime) {
            this.reloadTime = reloadTime;
        }

        public void firerate(IDifficultyProperty<Integer> firerate) {
            this.firerate = firerate;
        }

        public void damageMultiplier(IDifficultyProperty<Float> damageMultiplier) {
            this.damageMultiplier = damageMultiplier;
        }

        public void inaccuracy(float inaccuracy) {
            this.baseInaccuracy = inaccuracy;
        }

        public void accuracyBonus(float accuracyBonus) {
            this.accuracyBonus = accuracyBonus;
        }

        public void burstSize(int burstSize) {
            this.burstSize = burstSize;
        }

        public void burstDelay(IDifficultyProperty<Integer> burstDelay) {
            this.burstDelay = burstDelay;
        }

        public void cap(int capColor) {
            this.capColor = capColor;
        }

        public GunnerLoadoutInstance buildLoadout() {
            if (this.burstSize == 0) {
                this.burstSize = this.magCapacity;
            }
            Preconditions.checkState((this.weight > 0 ? 1 : 0) != 0, (Object)"Weight must be bigger than 0");
            Preconditions.checkNotNull((Object)this.weapon, (Object)"Weapon cannot be null");
            Preconditions.checkNotNull(this.ammo, (Object)"Ammo cannot be null");
            Preconditions.checkState((this.magCapacity > 0 ? 1 : 0) != 0, (Object)"Magazine capacity must be bigger than 0");
            Preconditions.checkNotNull(this.reloadTime, (Object)"Reload time cannot be null");
            Preconditions.checkNotNull(this.firerate, (Object)"Firerate cannot be null");
            Preconditions.checkNotNull(this.damageMultiplier, (Object)"Damage multiplier cannot be null");
            Preconditions.checkState((this.baseInaccuracy >= 0.0f ? 1 : 0) != 0, (Object)"Inaccuracy cannot be smaller than 0");
            Preconditions.checkState((this.accuracyBonus >= 0.0f ? 1 : 0) != 0, (Object)"Accuracy bonus cannot be smaller than 0");
            Preconditions.checkState((this.baseInaccuracy - 3.0f * this.accuracyBonus >= 0.0f ? 1 : 0) != 0, (Object)"(Inaccuracy-3*bonus) cannot be smaller than 0");
            Preconditions.checkState((this.burstSize >= 0 ? 1 : 0) != 0, (Object)"Burst size cannot be smaller than 0");
            Preconditions.checkNotNull(this.burstDelay, (Object)"Burst delay cannot be null");
            return new GunnerLoadoutInstance(this);
        }
    }
}

